# $Id: bootconf.spec.in,v 1.8 2008/05/08 11:50:58 mrsam Exp $

Summary: GRUB configuration utility
Name: bootconf
Version: 1.4
Release: 1
License: GPLv3
Group: System Environment/Base
Url: http://www.courier-mta.org/bootconf/
Source0: http://www.courier-mta.org/bootconf/download/%{name}-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildArch: noarch
BuildRequires: desktop-file-utils

%description
The bootconf configuration utility is a convenient tool for setting
GRUB kernel boot options.

%package gui
Summary: Desktop links to bootconf
Group: System Environment/Base
Requires: usermode
Requires: pygtk2
Requires: %{name} = 0:%{version}-%{release}

%description gui
This package installs links to bootconf into the Gnome menus.

%prep
%setup -q
%configure

%build
%{__make} %{_smp_mflags}

%install
%{__rm} -rf $RPM_BUILD_ROOT
%{__make} install DESTDIR=$RPM_BUILD_ROOT
%{__mkdir_p} $RPM_BUILD_ROOT%{_sysconfdir}/pam.d
%{__install} -p -m 0444 bootconf.pamconfig $RPM_BUILD_ROOT%{_sysconfdir}/pam.d/bootconf
%{__mkdir_p} $RPM_BUILD_ROOT%{_sysconfdir}/security/console.apps
%{__cat} >$RPM_BUILD_ROOT%{_sysconfdir}/security/console.apps/bootconf <<EOF
USER=root
PROGRAM=%{_sbindir}/bootconf
SESSION=true
EOF
%{__mkdir_p} $RPM_BUILD_ROOT%{_bindir}
%{__ln_s} consolehelper $RPM_BUILD_ROOT%{_bindir}/bootconf

%{__mkdir_p} $RPM_BUILD_ROOT%{_datadir}/applications

desktop-file-install --vendor="fedora" \
  --dir=${RPM_BUILD_ROOT}%{_datadir}/applications \
  bootconf.desktop 2>/dev/null || :

%find_lang %{name}
%clean
%{__rm} -rf $RPM_BUILD_ROOT

%post gui
%{_bindir}/update-desktop-database %{_datadir}/applications &>/dev/null || :

%postun gui
%{_bindir}/update-desktop-database %{_datadir}/applications &>/dev/null || :

%files -f %{name}.lang
%defattr(-,root,root,-)
%{_sbindir}/*
%doc COPYING README NEWS AUTHORS ChangeLog bootconf.html
%{_mandir}/man*/*

%files gui
%defattr(-,root,root,-)
%{_sysconfdir}/pam.d/*
%{_sysconfdir}/security/console.apps/*
%{_bindir}/*
%{_datadir}/applications/*

%changelog
* Wed May  7 2008 Mr. Sam <sam@email-scan.com> - 1.3-1
- Spec file/makefile update

* Sat May  3 2008 Mr. Sam <sam@email-scan.com> - 1.2-2
- Spec file update

* Tue Apr 29 2008 Mr. Sam <sam@email-scan.com> - 1.2-1
- Update spec file, minor fixes

* Sat Apr  8 2006 Mr. Sam <sam@email-scan.com> - 
- Initial build.

